//
// 8Connection.cpp: implementation of the C8Connection class.
//

#include "stdafx.h"

#include "8Connection.h"
#include "8Callback.h"


C8Connection::C8Connection()
{
	m_listener	= INVALID_SOCKET;
	m_socket	= INVALID_SOCKET;

	m_pPKPool = NULL;
}

C8Connection::~C8Connection()
{
	m_listener  = INVALID_SOCKET;
	m_socket    = INVALID_SOCKET;

	m_pPKPool = NULL;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::Create(	DWORD		dwIndex,
							HANDLE		hIOCP,
							SOCKET		listener,
							C8PKPool*	pPKPool )
{
	m_dwIndex	= dwIndex;
	m_hIOCP		= hIOCP;
	m_listener	= listener;
	m_pPKPool	= pPKPool;

	if( FALSE == this->Open() )
	{
		// ϸ  ؾ ϴ°?  ؼ Ŭ  Ŭ ȴ.
		return FALSE;
	}

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::Open()
{
#if 1
	if( !m_pPKPool )
		return FALSE;

	if( m_listener == INVALID_SOCKET )
		return FALSE;

	// create socket for send/recv
	m_socket = socket( AF_INET, SOCK_STREAM, 0 );

	if( m_socket == INVALID_SOCKET )
		return FALSE;

	// Accpet ü Ŷ۸ غѴ.
	LPOVERLAPPEDPLUS newolp = PrepareAcptPacket();

	if( NULL == newolp )
		return FALSE;

	BOOL bRet = AcceptEx( newolp->s,				// listen socket
						newolp->sclient,			// accept socket
						&(newolp->wbuf.buf[0]),		// output buffer
						MAXBUFSIZE,					// receive data length
						sizeof(sockaddr_in) + 16,	// local address length, TCP/IP should be set to the size of a SOCKADDR_IN +16
						sizeof(sockaddr_in) + 16,	// remote address length
						&newolp->dwBytes,			// bytes recieved
						&newolp->ol);				// overlapped

	if( !bRet && WSAGetLastError() != WSA_IO_PENDING )
	{
		printf( "%08X, AcceptEx(): SOCKET_ERROR, %d\n",
			m_dwIndex, WSAGetLastError() );
		closesocket( newolp->sclient );
		ReleaseAcptPacket( newolp );
		return FALSE;
	}

#else
	//  Լ   ϴ . 򸻿 ´.
	if( 0 == DisconnectEx(newolp->sclient,&newolp->ol,TF_REUSE_SOCKET,0) )
		return FALSE;
#endif

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::Close( LPOVERLAPPEDPLUS lpOverlapPlus, BOOL bForce )
{
	// Close()  CloseAndReInit() ǹ̰ ´.

	if( m_socket != INVALID_SOCKET && m_listener != INVALID_SOCKET )
	{
		struct linger li = {0, 0};	// Default: SO_DONTLINGER

		if( bForce )
			li.l_onoff = 1; // SO_LINGER, timeout = 0

		shutdown( m_listener, SD_BOTH );
		setsockopt( m_socket, SOL_SOCKET, SO_LINGER, (char *)&li, sizeof(li) );
		closesocket( m_socket );

		m_socket = INVALID_SOCKET;
	}

	if( NULL != lpOverlapPlus )
	{
		if( NULL != lpOverlapPlus->wbuf.buf &&
			NULL != m_pPKPool )
		{
			//  Ϸ Ǿ ü ۸ Ѵ.
			switch( lpOverlapPlus->OpCode )
			{
			case	OP_ACCEPT:
					ReleaseAcptPacket( lpOverlapPlus );
					break;

			case	OP_READ:
					ReleaseRecvPacket( lpOverlapPlus );
					break;

			case	OP_WRITE:
					ReleaseSendPacket( lpOverlapPlus );
					break;
			}
		}
	}

	if( FALSE == this->Open() )
	{
		// ϸ  ؾ ϴ°?  ؼ Ŭ  Ŭ ȴ.
		//   ¸ ǥְ üũ. ׸ ߿ Ÿ̸ӿ ٽ ʱȭ غ.
		printf( "Dead Connection.\n" );
		return FALSE;
	}

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::Shutdown( LPOVERLAPPEDPLUS lpOverlapPlus, BOOL bForce )
{
	if( m_socket != INVALID_SOCKET && m_listener != INVALID_SOCKET )
	{
		struct linger li = {0, 0};	// Default: SO_DONTLINGER

		if( bForce )
			li.l_onoff = 1; // SO_LINGER, timeout = 0

		shutdown( m_listener, SD_BOTH );
		setsockopt( m_socket, SOL_SOCKET, SO_LINGER, (char *)&li, sizeof(li) );
		closesocket( m_socket );

		m_socket = INVALID_SOCKET;
	}

	if( NULL != lpOverlapPlus )
	{
		if( NULL != lpOverlapPlus->wbuf.buf &&
			NULL != m_pPKPool )
		{
			//  Ϸ Ǿ ü ۸ Ѵ.
			switch( lpOverlapPlus->OpCode )
			{
			case	OP_ACCEPT:
					ReleaseAcptPacket( lpOverlapPlus );
					break;

			case	OP_READ:
					ReleaseRecvPacket( lpOverlapPlus );
					break;

			case	OP_WRITE:
					ReleaseSendPacket( lpOverlapPlus );
					break;
			}
		}
	}

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::DoIo( LPOVERLAPPEDPLUS lpOverlapPlus )
{
	switch( lpOverlapPlus->OpCode )
	{
	case OP_ACCEPT:

			BindIOCP( lpOverlapPlus );

			if( lpOverlapPlus->dwBytes )
			{
				if( FALSE == DispatchPacket(lpOverlapPlus) )
				{
					printf( "ACCEPT: failed to dispatch packet.\n" );
					this->Close( lpOverlapPlus, TRUE );
				}
				else
				{
					ReleaseAcptPacket( lpOverlapPlus );
				}
			}
			else
			{
				if( !RecvPost() )
					return FALSE;
			}

			break;

	case OP_READ:

			if( 0 == lpOverlapPlus->dwBytes )
			{
				this->Close( lpOverlapPlus, FALSE );
			}
			else
			if( SOCKET_ERROR == (int)lpOverlapPlus->dwBytes )
			{
				this->Close( lpOverlapPlus, TRUE );
			}
			else
			{
				if( FALSE == DispatchPacket(lpOverlapPlus) )
				{
					printf( "READ: failed to dispatch packet.\n" );
					this->Close( lpOverlapPlus, TRUE );
				}
				else
					ReleaseRecvPacket( lpOverlapPlus );
			}

			break;
		
	case OP_WRITE:

			if( 0 == lpOverlapPlus->dwBytes )
			{
				this->Close( lpOverlapPlus, FALSE );
			}
			else
			if( SOCKET_ERROR == (int)lpOverlapPlus->dwBytes )
			{
				this->Close( lpOverlapPlus, TRUE );
			}
			else
			{
				ReleaseSendPacket( lpOverlapPlus );
			}

			break;
	}

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
LPOVERLAPPEDPLUS C8Connection::PrepareAcptPacket()
{
	LPOVERLAPPEDPLUS newolp = NULL;

	// get accept overlapped structure and packet buffer.
	if( FALSE == m_pPKPool->AllocAcptPacket(newolp) )
	{
		printf( "%08X, acpt packet alloc failed\n", m_dwIndex );
		return NULL;
	}

	assert( newolp );

	// clear buffer
	memset( &newolp->ol, 0, sizeof(OVERLAPPED) );
	memset( &newolp->wbuf.buf[0], 0, sizeof(MAXPACKETSIZE) );

	// init olp structure
	newolp->s			= m_listener;
	newolp->sclient		= m_socket;
	newolp->OpCode		= OP_ACCEPT;
	newolp->pConnection = (PVOID) this;
	newolp->dwRemain	= 0;
	newolp->wbuf.len	= MAXPACKETSIZE;

	return newolp;
}
//////////////////////////////////////////////////////////////////////
LPOVERLAPPEDPLUS C8Connection::PrepareRecvPacket( char *psrcbuf, UINT srclen )
{
	assert( srclen <= MAXPACKETSIZE );

	LPOVERLAPPEDPLUS newolp = NULL;

	// get recv overlapped structure and packet buffer.
	if( FALSE == m_pPKPool->AllocRecvPacket(newolp) )
	{
		printf( "%08X, recv packet alloc failed\n", m_dwIndex );
		return NULL;
	}

	assert( newolp );

	// clear buffer
	memset( &newolp->ol, 0, sizeof(OVERLAPPED) );
	memset( &newolp->wbuf.buf[0], 0, sizeof(MAXPACKETSIZE) );

	// init olp structure
	newolp->s			= m_listener;
	newolp->sclient		= m_socket;
	newolp->OpCode		= OP_READ;
	newolp->pConnection = (PVOID) this;
	newolp->dwRemain	= 0;
	newolp->wbuf.len	= MAXPACKETSIZE; // 

	// remained packet copy
	if( srclen )
	{
		printf( "%08X, splitted recv buffer(%s,%d)\n",
			m_dwIndex, psrcbuf, srclen );
		memcpy( newolp->wbuf.buf, &psrcbuf[0], srclen );
		newolp->wbuf.buf = &(newolp->wbuf.buf[srclen]);
		newolp->dwRemain = srclen;
	}

	return newolp;
}
//////////////////////////////////////////////////////////////////////
LPOVERLAPPEDPLUS C8Connection::PrepareSendPacket( char *psrcbuf, UINT srclen )
{
	assert( srclen > 0 && srclen <= MAXPACKETSIZE );

	LPOVERLAPPEDPLUS newolp = NULL;

	// get send overlapped structure and packet buffer.
	if( FALSE == m_pPKPool->AllocSendPacket(newolp) )
	{
		printf( "%08X, send packet alloc failed\n", m_dwIndex );
		return NULL;
	}

	assert( newolp );

	// clear buffer
	memset( &newolp->ol, 0, sizeof(OVERLAPPED) );
	memset( &newolp->wbuf.buf[0], 0, sizeof(MAXPACKETSIZE) );

	// init olp structure
	newolp->s			= m_listener;
	newolp->sclient		= m_socket;
	newolp->OpCode		= OP_WRITE;
	newolp->pConnection	= (PVOID) this;
	newolp->dwRemain	= 0;
	newolp->wbuf.len	= srclen; // srclen

	memcpy( newolp->wbuf.buf, psrcbuf, srclen );

	return newolp;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::ReleaseAcptPacket( LPOVERLAPPEDPLUS olp )
{
	//
	if( NULL == olp )			return FALSE;
	if( NULL == olp->wbuf.buf )	return FALSE;

	if( FALSE == m_pPKPool->FreeAcptPacket(olp) )
	{
		printf( "%08X, free acpt packet failed\n", m_dwIndex );
		return FALSE;
	}

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::ReleaseRecvPacket( LPOVERLAPPEDPLUS olp )
{
	//
	if( NULL == olp )			return FALSE;
	if( NULL == olp->wbuf.buf )	return FALSE;

	if( FALSE == m_pPKPool->FreeRecvPacket(olp) )
	{
		printf( "%08X, free recv packet failed\n", m_dwIndex );
		return FALSE;
	}
	return TRUE;
}
//////////////////////////////////////////////////////////////////////
BOOL C8Connection::ReleaseSendPacket( LPOVERLAPPEDPLUS olp )
{
	//
	if( NULL == olp )			return FALSE;
	if( NULL == olp->wbuf.buf )	return FALSE;

	if( FALSE == m_pPKPool->FreeSendPacket(olp) )
	{
		printf( "%08X, free send packet failed\n", m_dwIndex );
		return FALSE;
	}
	return TRUE;
}


//////////////////////////////////////////////////////////////////////
BOOL C8Connection::BindIOCP( LPOVERLAPPEDPLUS lpOverlapPlus )
{
	// never became NULL
	assert( lpOverlapPlus );

	int				locallen,
					remotelen;

	sockaddr_in *	plocal	= 0,
				*	premote	= 0;

	GetAcceptExSockaddrs(
		&(lpOverlapPlus->wbuf.buf[0]),
		MAXBUFSIZE,
		sizeof(sockaddr_in) + 16,
		sizeof(sockaddr_in) + 16,
		(sockaddr **)&plocal,
		&locallen,
		(sockaddr **)&premote,
		&remotelen
	);

	memcpy( &m_local, plocal, sizeof(sockaddr_in) );
	memcpy( &m_peer, premote, sizeof(sockaddr_in) );

	if( 0 == CreateIoCompletionPort((HANDLE)lpOverlapPlus->sclient,m_hIOCP,0,0) )
		return FALSE;
//	if( 0 == BindIoCompletionCallback((HANDLE)lpOverlapPlus->sclient,
//		IoCompletionCallback,0) )
//		return FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL C8Connection::DispatchPacket( LPOVERLAPPEDPLUS lpOverlapPlus )
{
	char * psrcbuf     = &( lpOverlapPlus->wbuf.buf[0] );
	int     srclen     =    lpOverlapPlus->dwBytes;

	// Echo Ư  Ŷ DispatchҰ͵ ,
	//DecodePacket(psrcbuf,srclen); ȣȭ Ŷ ڵѴ.
	//ProcessEvent(psrcbuf,srclen); ڵ Ŷ óѴ.

	//  Ŷ ״ ٽ SendPostѴ.
	if( !SendPost(psrcbuf,srclen) )
		return FALSE;

	// ׸ ο recieve buffer غϿ PostѴ.
	if( !RecvPost() )
		return FALSE;

	return TRUE;
}

BOOL C8Connection::SendPost( char *pbuf, UINT buflen )
{
	// prepare send packet
	LPOVERLAPPEDPLUS newolp	= PrepareSendPacket( pbuf, buflen );
	if( NULL == newolp )
		return FALSE;

	int ret = WSASend(
		newolp->sclient,
		&newolp->wbuf,
		1,
		&newolp->dwBytes,
		0,
		&newolp->ol,
		NULL );
	
	if( ret == SOCKET_ERROR && WSAGetLastError() != WSA_IO_PENDING )
	{
		printf( "%08X, WSASend(): SOCKET_ERROR, %d\n",
			m_dwIndex, WSAGetLastError() );
		ReleaseSendPacket( newolp );
		return FALSE;
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL C8Connection::RecvPost( char *pbuf, UINT buflen )
{
	// prepare recieve buffer
	LPOVERLAPPEDPLUS newolp = PrepareRecvPacket( pbuf, buflen );

	if( NULL == newolp )
		return FALSE;

	int ret = WSARecv(
		newolp->sclient,
		&newolp->wbuf,
		1,
		&newolp->dwBytes, //  ȣ ٷ ޾Ҵٸ   ũⰡ Ѿ iocp ǹ̰ .
		&newolp->dwFlags,
		&newolp->ol,
		NULL );
	
	if( ret == SOCKET_ERROR && WSAGetLastError() != WSA_IO_PENDING )
	{
		printf( "%08X, WSARecv(): SOCKET_ERROR, %d\n",
			m_dwIndex, WSAGetLastError() );
		ReleaseRecvPacket( newolp );
		return FALSE;
	}

	return TRUE;
}
